/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;
import dangerzone.particles.Particle;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Hoverboard
extends EntityLiving {
    Texture texture2 = null;
    Texture texture3 = null;
    Texture texture4 = null;
    Texture texture5 = null;
    Texture texture6 = null;
    Texture texture7 = null;
    Texture texture8 = null;
    Texture texture9 = null;
    Texture texture10 = null;
    private int breakdown = 0;

    public Hoverboard(World w) {
        super(w);
        this.maxrenderdist = 64;
        this.height = 1.75f;
        this.width = 0.75f;
        this.uniquename = "OreSpawn:Hoverboard";
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 10000;
        this.setExperience(0);
        this.canSwim = false;
        this.sit_when_riding = false;
        this.takesFallDamage = false;
        this.setCanDespawn(false);
        this.tower_defense_enable = false;
        this.setGroundFactor(1.75f);
        this.setAirFactor(1.75f);
    }

    public Texture getTexture() {
        int which;
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Hoverboardtexture1.png");
            this.texture2 = TextureMapper.getTexture((String)"orespawnres/skins/Hoverboardtexture2.png");
            this.texture3 = TextureMapper.getTexture((String)"orespawnres/skins/Hoverboardtexture3.png");
            this.texture4 = TextureMapper.getTexture((String)"orespawnres/skins/Hoverboardtexture4.png");
            this.texture5 = TextureMapper.getTexture((String)"orespawnres/skins/Hoverboardtexture5.png");
            this.texture6 = TextureMapper.getTexture((String)"orespawnres/skins/Hoverboardtexture6.png");
            this.texture7 = TextureMapper.getTexture((String)"orespawnres/skins/Hoverboardtexture7.png");
            this.texture8 = TextureMapper.getTexture((String)"orespawnres/skins/Hoverboardtexture8.png");
            this.texture9 = TextureMapper.getTexture((String)"orespawnres/skins/Hoverboardtexture9.png");
            this.texture10 = TextureMapper.getTexture((String)"orespawnres/skins/Hoverboardtexture10.png");
        }
        if ((which = this.getIID()) == 1) {
            return this.texture2;
        }
        if (which == 2) {
            return this.texture3;
        }
        if (which == 3) {
            return this.texture4;
        }
        if (which == 4) {
            return this.texture5;
        }
        if (which == 5) {
            return this.texture6;
        }
        if (which == 6) {
            return this.texture7;
        }
        if (which == 7) {
            return this.texture8;
        }
        if (which == 8) {
            return this.texture9;
        }
        if (which == 9) {
            return this.texture10;
        }
        return this.texture;
    }

    public void doDeathDrops() {
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.hoverboard.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
    }

    public void update(float deltaT) {
        if (this.world.isServer) {
            if (this.world.rand.nextInt(80) == 1) {
                this.playliving();
            }
        } else {
            Entity rider = this.getRiderEntity();
            float velocity = (float)Math.sqrt(this.motionx * this.motionx + this.motionz * this.motionz);
            float gh = 0.25f;
            if (rider != null) {
                float dz;
                float dx;
                int howmany = 1 + this.world.rand.nextInt(2);
                boolean shorter = false;
                Particle eb = null;
                int i = 0;
                while (i < howmany) {
                    int which = this.world.rand.nextInt(3);
                    dx = (float)Math.sin(Math.toRadians(this.rotation_yaw + 180.0f));
                    dz = (float)Math.cos(Math.toRadians(this.rotation_yaw + 180.0f));
                    if (this.world.rand.nextBoolean()) {
                        shorter = true;
                        dx = (float)Math.sin(Math.toRadians(this.rotation_yaw + 195.0f));
                        dz = (float)Math.cos(Math.toRadians(this.rotation_yaw + 195.0f));
                        if (this.world.rand.nextBoolean()) {
                            dx = (float)Math.sin(Math.toRadians(this.rotation_yaw + 165.0f));
                            dz = (float)Math.cos(Math.toRadians(this.rotation_yaw + 165.0f));
                        }
                    }
                    dx += (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f;
                    dz += (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f;
                    if (which == 0) {
                        eb = this.world.createParticleByName("DangerZone:ParticleDust", this.dimension, this.posx + (double)dx, this.posy + (double)0.45f, this.posz + (double)dz);
                    }
                    if (which == 1) {
                        eb = this.world.createParticleByName("DangerZone:ParticleBreak", this.dimension, this.posx + (double)dx, this.posy + (double)0.45f, this.posz + (double)dz);
                    }
                    if (which == 2) {
                        eb = this.world.createParticleByName("DangerZone:ParticleSmoke", this.dimension, this.posx + (double)dx, this.posy + (double)0.45f, this.posz + (double)dz);
                    }
                    if (eb != null) {
                        eb.motiony = 0.0f;
                        dx = (float)Math.sin(Math.toRadians(this.rotation_yaw + 180.0f));
                        dz = (float)Math.cos(Math.toRadians(this.rotation_yaw + 180.0f));
                        eb.motionx = dx * 0.18f;
                        eb.motionz = dz * 0.18f;
                        eb.maxlifetime = 10 + this.world.rand.nextInt(10);
                        if (shorter) {
                            eb.maxlifetime = 5 + this.world.rand.nextInt(5);
                        }
                        this.world.spawnParticleInWorld(eb);
                    }
                    ++i;
                }
                rider.motiony += 0.17f * (deltaT /= 6.0f);
                gh = 3.25f;
                int bid = this.world.getblock(this.dimension, (int)this.posx, (int)((float)this.posy - gh), (int)this.posz);
                if (bid != 0) {
                    rider.motiony += 0.18f * deltaT;
                }
                float obstruction_factor = 0.0f;
                float dist = 4.0f;
                dist += (float)((int)(velocity * 8.0f));
                int k = -2;
                while (k < (int)(3.0f + rider.getHeight())) {
                    i = 0;
                    while ((float)i < dist) {
                        int j = -10;
                        while (j <= 10) {
                            dx = (float)((double)i * Math.sin(Math.toRadians(this.rotation_yaw + (float)j)));
                            bid = this.world.getblock(this.dimension, (int)(this.posx + (double)dx), (int)this.posy + k, (int)(this.posz + (double)(dz = (float)((double)i * Math.cos(Math.toRadians(this.rotation_yaw + (float)j))))));
                            if (bid != 0) {
                                obstruction_factor += 0.15f;
                            }
                            j += 10;
                        }
                        ++i;
                    }
                    ++k;
                }
                rider.motiony += obstruction_factor * 0.03f * deltaT;
            }
        }
        super.update(deltaT);
    }

    private void playliving() {
        int which = this.world.rand.nextInt(6);
        if (which == 0) {
            this.world.playSound("OreSpawn:hover1", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
        }
        if (which == 1) {
            this.world.playSound("OreSpawn:hover2", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
        }
        if (which == 2) {
            this.world.playSound("OreSpawn:hover3", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
        }
        if (which == 3) {
            this.world.playSound("OreSpawn:hover4", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
        }
        if (which == 4) {
            this.world.playSound("OreSpawn:hover5", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
        }
        if (which == 5) {
            this.world.playSound("OreSpawn:hover6", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f);
        }
    }

    public String getHurtSound() {
        return null;
    }

    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer) {
            if (ic == null) {
                if (this.isMountedBy((Entity)p)) {
                    this.unMount((Entity)p);
                } else {
                    this.Mount((Entity)p);
                }
            } else {
                Item it = ic.getItem();
                if (it != null && it.itemID == OreSpawnMain.ultimatesword.itemID) {
                    int id = this.getIID();
                    if (++id > 9) {
                        id = 0;
                    }
                    this.setIID(id);
                }
            }
        }
        return false;
    }

    public float getRiderYoffset() {
        return 0.5f;
    }

    public float getRiderXZoffset() {
        return 0.0f;
    }

    public void doEntityAction(float deltaT) {
        Entity rider = this.getRiderEntity();
        float gh = 0.25f;
        if (rider == null) {
            this.motiony += 0.15f * deltaT;
            int bid = this.world.getblock(this.dimension, (int)this.posx, (int)((float)this.posy - gh + 1.0f), (int)this.posz);
            if (bid == 0) {
                bid = this.world.getblock(this.dimension, (int)this.posx, (int)((float)this.posy - gh), (int)this.posz);
            }
            if (bid != 0) {
                this.motiony += 0.14f * deltaT;
            }
            return;
        }
        if (!(rider instanceof Player)) {
            super.doEntityAction(deltaT);
            return;
        }
        if (this.breakdown > 0) {
            ++this.breakdown;
            if (this.breakdown > 50) {
                this.breakdown = 0;
            }
            if (this.breakdown == 1) {
                this.world.playSound("DangerZone:small_explosion1", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                this.setOnFire(10);
            }
            int i = 0;
            while (i < 10) {
                Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleSparkle", (int)5, (int)this.dimension, (double)(this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 1.5f)), (double)(this.posy + (double)(this.world.rand.nextFloat() * 2.0f)), (double)(this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 1.5f)));
                Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleSmoke", (int)5, (int)this.dimension, (double)(this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 1.5f)), (double)(this.posy + (double)(this.world.rand.nextFloat() * 2.0f)), (double)(this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 1.5f)));
                Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleFire", (int)5, (int)this.dimension, (double)(this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 1.5f)), (double)(this.posy + (double)(this.world.rand.nextFloat() * 2.0f)), (double)(this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 1.5f)));
                ++i;
            }
            return;
        }
        if (this.world.rand.nextInt(6000) == 1) {
            this.breakdown = 1;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.toRadians(rider.rotation_yaw);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        if (ddiff > 0.3f) {
            ddiff = 0.3f;
        }
        if (ddiff < -0.3f) {
            ddiff = -0.3f;
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 5.0);
    }

    public void setBaby(boolean tf) {
    }
}

